/*! \file 
**********************************************************************************
* Title:                            Discretix SST API Types header file
*
* Filename:                         nvs_def.h
*
* Project, Target, subsystem:       NVS, Host IF
* 
* Created:                          26.07.2007
*
* Modified:                         26.07.2007
*
* \Author                           Ira Boguslavsky
*
* \Remarks                        
*           Copyright (C) 2006 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

#ifndef _NVS_DEF_H_
#define _NVS_DEF_H_

/*
* All the includes that are needed for code using this module to
* compile correctly should be #included here.
*/

#ifdef __cplusplus
extern "C"
{
#endif
    /************************ Defines ******************************/
    typedef enum
    {
        NVS_INVALID_PARAM,

        NVS_ErrorCodesLast= 0x7FFFFFFF,

    }NVS_ErrorCodes;

	#define NVS_THREAD_THREAD_NAME              "NVS Thread"
	#define NVS_THREAD_SEMAPHORE_NAME           "NVS Thread Semaphore"
	#define NVS_THREAD_SEMAPHORE_INIT_VALUE     (0x01UL)

	#define SEP_DRIVER_NVS_EVENT                (0x2UL)


	/* Define protocol shared memory address */
	extern DxUint32_t g_SharedRamAddr;
	#define DX_PROTOCOL_SHARED_MEMORY_ADDRESS			(g_SharedRamAddr) 
	#define DX_PROTOCOL_SHARED_MEMORY_OP_CODE_ADDRESS	(DX_PROTOCOL_SHARED_MEMORY_ADDRESS+8)


	/*return the round up size to a multiple of word*/
	#define NVS_THREAD_WORD_ROUND_UP(sizeInBytes)	(((sizeInBytes) & (0x3)) ? \
													((((sizeInBytes)/(sizeof(DxUint32_t)))+1)\
													*(sizeof(DxUint32_t))) : (sizeInBytes)) 
    
    
    /** TAKEN FROM sst_host_util.h  BEGIN-> **/
    
    #define DX_1_WORD_PARAM                         (1UL)
    #define DX_2_WORDS_PARAMS                       (2UL)
    #define DX_3_WORDS_PARAMS                       (3UL)
    #define DX_4_WORDS_PARAMS                       (4UL)

    typedef enum
    {
        DX_BIG_ENDIAN      = 0,
        DX_LITTLE_ENDIAN   = 1,

        SSTEndianessLast  = 0x7FFFFFFF,

    }SSTEndianess_t;


    /* Define endianess flag*/
    #define DX_ENDIANESS_FLAG                       DX_BIG_ENDIAN

    /** TAKEN FROM sst_host_util.h  <-END **/
    
#ifdef __cplusplus
}
#endif

#endif
